/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.netty.util.AttributeKey;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.geysermc.event.PostOrder;
import org.geysermc.floodgate.addon.data.HandshakeHandlersImpl;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.event.FloodgateEventBus;
import org.geysermc.floodgate.api.handshake.HandshakeHandlers;
import org.geysermc.floodgate.api.inject.PlatformInjector;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ConfigLoader;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.crypto.AesCipher;
import org.geysermc.floodgate.crypto.AesKeyProducer;
import org.geysermc.floodgate.crypto.Base64Topping;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.KeyProducer;
import org.geysermc.floodgate.event.EventBus;
import org.geysermc.floodgate.event.lifecycle.ShutdownEvent;
import org.geysermc.floodgate.event.util.ListenerAnnotationMatcher;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.link.PlayerLinkHolder;
import org.geysermc.floodgate.module.AutoBindModule;
import org.geysermc.floodgate.packet.PacketHandlersImpl;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.skin.SkinUploadManager;
import org.geysermc.floodgate.util.Constants;
import org.geysermc.floodgate.util.HttpClient;
import org.geysermc.floodgate.util.LanguageManager;

public class CommonModule
extends AbstractModule {
    private final EventBus eventBus = new EventBus();
    private final Path dataDirectory;

    protected void configure() {
        this.bind(EventBus.class).toInstance((Object)this.eventBus);
        this.bind(FloodgateEventBus.class).to(EventBus.class);
        this.bindListener((Matcher)new ListenerAnnotationMatcher(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                encounter.register(CommonModule.this.eventBus::register);
            }
        });
        ExecutorService commonPool = Executors.newCachedThreadPool();
        ScheduledExecutorService commonScheduledPool = Executors.newSingleThreadScheduledExecutor();
        this.eventBus.subscribe(ShutdownEvent.class, ignored -> {
            commonPool.shutdown();
            commonScheduledPool.shutdown();
        }, PostOrder.LAST);
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)"commonPool")).toInstance((Object)commonPool);
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"commonScheduledPool")).toInstance((Object)commonScheduledPool);
        this.bind(HttpClient.class).in(Singleton.class);
        this.bind(FloodgateApi.class).to(SimpleFloodgateApi.class);
        this.bind(PlatformInjector.class).to(CommonPlatformInjector.class);
        this.bind(HandshakeHandlers.class).to(HandshakeHandlersImpl.class);
        this.bind(HandshakeHandlersImpl.class).in(Singleton.class);
        this.bind(PacketHandlers.class).to(PacketHandlersImpl.class);
        this.bind(PacketHandlersImpl.class).asEagerSingleton();
        this.install((Module)new AutoBindModule());
    }

    @Provides
    @Singleton
    public FloodgateConfig floodgateConfig(ConfigLoader configLoader) {
        return configLoader.load();
    }

    @Provides
    @Singleton
    public PlayerLink playerLink(PlayerLinkHolder linkLoader) {
        return linkLoader.load();
    }

    @Provides
    @Singleton
    public KeyProducer keyProducer() {
        return new AesKeyProducer();
    }

    @Provides
    @Singleton
    public FloodgateCipher cipher() {
        return new AesCipher(new Base64Topping());
    }

    @Provides
    @Singleton
    @Named(value="dataDirectory")
    public Path dataDirectory() {
        return this.dataDirectory;
    }

    @Provides
    @Singleton
    public ConfigLoader configLoader(@Named(value="configClass") Class<? extends FloodgateConfig> configClass, KeyProducer producer, FloodgateCipher cipher) {
        return new ConfigLoader(this.dataDirectory, configClass, producer, cipher);
    }

    @Provides
    @Singleton
    public FloodgateHandshakeHandler handshakeHandler(HandshakeHandlersImpl handshakeHandlers, SimpleFloodgateApi api, FloodgateCipher cipher, FloodgateConfig config, SkinUploadManager skinUploadManager, @Named(value="playerAttribute") AttributeKey<FloodgatePlayer> playerAttribute, FloodgateLogger logger, LanguageManager languageManager) {
        return new FloodgateHandshakeHandler(handshakeHandlers, api, cipher, config, skinUploadManager, playerAttribute, logger, languageManager);
    }

    @Provides
    @Singleton
    public PluginMessageManager pluginMessageManager() {
        return new PluginMessageManager();
    }

    @Provides
    @Singleton
    @Named(value="gitBranch")
    public String gitBranch() {
        return "master";
    }

    @Provides
    @Singleton
    @Named(value="buildNumber")
    public int buildNumber() {
        return Constants.BUILD_NUMBER;
    }

    @Provides
    @Singleton
    @Named(value="kickMessageAttribute")
    public AttributeKey<String> kickMessageAttribute() {
        return AttributeKey.valueOf((String)"floodgate-kick-message");
    }

    @Provides
    @Singleton
    @Named(value="playerAttribute")
    public AttributeKey<FloodgatePlayer> playerAttribute() {
        return AttributeKey.valueOf((String)"floodgate-player");
    }

    public CommonModule(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
    }
}

