/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.util.GameProfile;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityListener {
    private static final Field INITIAL_MINECRAFT_CONNECTION;
    private static final Field INITIAL_CONNECTION_DELEGATE;
    private static final Field CHANNEL;
    private final Cache<InboundConnection, FloodgatePlayer> playerCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(20L, TimeUnit.SECONDS).build();
    @Inject
    private ProxyFloodgateConfig config;
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;

    @Subscribe(order=PostOrder.EARLY)
    public void onPreLogin(PreLoginEvent event) {
        String kickMessage;
        FloodgatePlayer player = null;
        try {
            InboundConnection connection = event.getConnection();
            if (INITIAL_CONNECTION_DELEGATE != null) {
                connection = (InboundConnection)ReflectionUtils.getCastedValue((Object)connection, INITIAL_CONNECTION_DELEGATE);
            }
            Object mcConnection = ReflectionUtils.getValue((Object)connection, INITIAL_MINECRAFT_CONNECTION);
            Channel channel = (Channel)ReflectionUtils.getCastedValue(mcConnection, CHANNEL);
            player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
            kickMessage = (String)channel.attr(this.kickMessageAttribute).get();
        }
        catch (Exception exception) {
            this.logger.error("Failed get the FloodgatePlayer from the player's channel", exception, new Object[0]);
            kickMessage = "Failed to get the FloodgatePlayer from the players's Channel";
        }
        if (kickMessage != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)kickMessage)));
            return;
        }
        if (player != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            this.playerCache.put((Object)event.getConnection(), (Object)player);
        }
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onGameProfileRequest(GameProfileRequestEvent event) {
        FloodgatePlayer player = (FloodgatePlayer)this.playerCache.getIfPresent((Object)event.getConnection());
        if (player != null) {
            this.playerCache.invalidate((Object)event.getConnection());
            GameProfile profile = new GameProfile(player.getCorrectUniqueId(), player.getCorrectUsername(), Collections.emptyList());
            if (!this.config.isSendFloodgateData() && !player.isLinked()) {
                profile = profile.addProperty(new GameProfile.Property("textures", "", ""));
            }
            event.setGameProfile(profile);
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onLogin(LoginEvent event) {
        FloodgatePlayer player;
        if (event.getResult().isAllowed() && (player = this.api.getPlayer(event.getPlayer().getUniqueId())) != null) {
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onDisconnect(DisconnectEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }

    static {
        Class<?> initialConnection = ReflectionUtils.getPrefixedClass("connection.client.InitialInboundConnection");
        Class<?> minecraftConnection = ReflectionUtils.getPrefixedClass("connection.MinecraftConnection");
        INITIAL_MINECRAFT_CONNECTION = ReflectionUtils.getFieldOfType(initialConnection, minecraftConnection);
        Class<?> loginInboundConnection = ReflectionUtils.getPrefixedClassSilently("connection.client.LoginInboundConnection");
        if (loginInboundConnection != null) {
            INITIAL_CONNECTION_DELEGATE = ReflectionUtils.getField(loginInboundConnection, "delegate");
            Objects.requireNonNull(INITIAL_CONNECTION_DELEGATE, "initial inbound connection delegate cannot be null");
        } else {
            INITIAL_CONNECTION_DELEGATE = null;
        }
        CHANNEL = ReflectionUtils.getFieldOfType(minecraftConnection, Channel.class);
    }
}

