/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command;

import com.google.inject.Inject;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.command.CommonCommandMessage;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.link.GlobalPlayerLinking;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.Command;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;

public final class UnlinkAccountCommand
implements FloodgateCommand {
    @Inject
    private FloodgateApi api;

    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        return commandManager.commandBuilder("unlinkaccount", ArgumentDescription.of("Unlink your Java account from your Bedrock account"), new String[0]).senderType(UserAudience.PlayerAudience.class).permission(Permission.COMMAND_UNLINK.get()).handler(this::execute).build();
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        UserAudience sender = context.getSender();
        PlayerLink link = this.api.getPlayerLink();
        if (link instanceof GlobalPlayerLinking) {
            if (((GlobalPlayerLinking)link).getDatabaseImpl() != null) {
                sender.sendMessage(CommonCommandMessage.LOCAL_LINKING_NOTICE, "https://link.geysermc.org/");
            } else {
                sender.sendMessage(CommonCommandMessage.GLOBAL_LINKING_NOTICE, "https://link.geysermc.org/");
                return;
            }
        }
        if (!link.isEnabledAndAllowed()) {
            sender.sendMessage(CommonCommandMessage.LINKING_DISABLED, new Object[0]);
            return;
        }
        link.isLinkedPlayer(sender.uuid()).whenComplete((linked, error) -> {
            if (error != null) {
                sender.sendMessage(CommonCommandMessage.IS_LINKED_ERROR, new Object[0]);
                return;
            }
            if (!linked.booleanValue()) {
                sender.sendMessage(Message.NOT_LINKED, new Object[0]);
                return;
            }
            link.unlinkPlayer(sender.uuid()).whenComplete((unused, error1) -> {
                if (error1 != null) {
                    sender.sendMessage(Message.UNLINK_ERROR, new Object[0]);
                    return;
                }
                sender.sendMessage(Message.UNLINK_SUCCESS, new Object[0]);
            });
        });
    }

    @Override
    public boolean shouldRegister(FloodgateConfig config) {
        FloodgateConfig.PlayerLinkConfig linkConfig = config.getPlayerLink();
        return linkConfig.isEnabled() && (linkConfig.isEnableOwnLinking() || linkConfig.isEnableGlobalLinking());
    }

    public static enum Message implements TranslatableMessage
    {
        NOT_LINKED("floodgate.command.unlink_account.not_linked"),
        UNLINK_SUCCESS("floodgate.command.unlink_account.unlink_success"),
        UNLINK_ERROR("floodgate.command.unlink_account.error " + CommonCommandMessage.CHECK_CONSOLE);

        private final String rawMessage;
        private final String[] translateParts;

        private Message(String rawMessage) {
            this.rawMessage = rawMessage;
            this.translateParts = rawMessage.split(" ");
        }

        @Override
        public String getRawMessage() {
            return this.rawMessage;
        }

        @Override
        public String[] getTranslateParts() {
            return this.translateParts;
        }
    }
}

