/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityServerDataHandler
extends ChannelOutboundHandlerAdapter {
    private static final Class<?> HANDSHAKE_PACKET = ReflectionUtils.getPrefixedClass("protocol.packet.Handshake");
    private static final Field HANDSHAKE_ADDRESS;
    private static final Method GET_ASSOCIATION;
    private static final Method GET_FORWARDING_MODE;
    private static final Method GET_PLAYER;
    private final ProxyFloodgateApi api;
    private final boolean isModernForwarding;

    public VelocityServerDataHandler(ProxyFloodgateApi api, ProxyServer proxy) {
        this.api = api;
        Enum forwardingMode = (Enum)ReflectionUtils.castedInvoke(proxy.getConfiguration(), GET_FORWARDING_MODE, new Object[0]);
        this.isModernForwarding = "MODERN".equals(forwardingMode.name());
    }

    public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) throws Exception {
        if (HANDSHAKE_PACKET.isInstance(packet)) {
            String address = (String)ReflectionUtils.getCastedValue(packet, HANDSHAKE_ADDRESS);
            ChannelHandler minecraftConnection = ctx.pipeline().get("handler");
            Object association = ReflectionUtils.invoke(minecraftConnection, GET_ASSOCIATION, new Object[0]);
            Player velocityPlayer = (Player)ReflectionUtils.castedInvoke(association, GET_PLAYER, new Object[0]);
            FloodgatePlayer player = this.api.getPlayer(velocityPlayer.getUniqueId());
            if (player != null) {
                String remaining;
                String originalAddress;
                BedrockData data = player.as(FloodgatePlayerImpl.class).toBedrockData();
                String encryptedData = this.api.createEncryptedDataString(data);
                int addressFinished = address.indexOf(0);
                if (this.isModernForwarding && addressFinished == -1) {
                    originalAddress = address;
                    remaining = "";
                } else {
                    originalAddress = address.substring(0, addressFinished);
                    remaining = address.substring(addressFinished);
                }
                ReflectionUtils.setValue(packet, HANDSHAKE_ADDRESS, (Object)(originalAddress + "\u0000" + encryptedData + remaining));
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.write(packet, promise);
    }

    static {
        Preconditions.checkNotNull(HANDSHAKE_PACKET, (Object)"Handshake packet class cannot be null");
        HANDSHAKE_ADDRESS = ReflectionUtils.getField(HANDSHAKE_PACKET, "serverAddress");
        Preconditions.checkNotNull((Object)HANDSHAKE_ADDRESS, (Object)"Address field of the Handshake packet cannot be null");
        Class<?> minecraftConnection = ReflectionUtils.getPrefixedClass("connection.MinecraftConnection");
        GET_ASSOCIATION = ReflectionUtils.getMethod(minecraftConnection, "getAssociation", new Class[0]);
        Preconditions.checkNotNull((Object)GET_ASSOCIATION, (Object)"getAssociation in MinecraftConnection cannot be null");
        Class<?> configClass = ReflectionUtils.getPrefixedClass("config.VelocityConfiguration");
        GET_FORWARDING_MODE = ReflectionUtils.getMethod(configClass, "getPlayerInfoForwardingMode", new Class[0]);
        Preconditions.checkNotNull((Object)GET_FORWARDING_MODE, (Object)"getPlayerInfoForwardingMode in VelocityConfiguration cannot be null");
        Class<?> serverConnection = ReflectionUtils.getPrefixedClass("connection.backend.VelocityServerConnection");
        GET_PLAYER = ReflectionUtils.getMethod(serverConnection, "getPlayer", new Class[0]);
        Preconditions.checkNotNull((Object)GET_PLAYER, (Object)"getPlayer in VelocityServerConnection cannot be null");
    }
}

