/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.com.google.inject.internal;

import java.util.List;
import java.util.Set;
import org.geysermc.floodgate.shadow.com.google.common.collect.ImmutableList;
import org.geysermc.floodgate.shadow.com.google.common.collect.Lists;
import org.geysermc.floodgate.shadow.com.google.inject.ConfigurationException;
import org.geysermc.floodgate.shadow.com.google.inject.Stage;
import org.geysermc.floodgate.shadow.com.google.inject.TypeLiteral;
import org.geysermc.floodgate.shadow.com.google.inject.internal.AbstractProcessor;
import org.geysermc.floodgate.shadow.com.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.com.google.inject.internal.Initializer;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalContext;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalProvisionException;
import org.geysermc.floodgate.shadow.com.google.inject.internal.SingleMemberInjector;
import org.geysermc.floodgate.shadow.com.google.inject.spi.InjectionRequest;
import org.geysermc.floodgate.shadow.com.google.inject.spi.StaticInjectionRequest;

final class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = Lists.newArrayList();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest request) {
        this.staticInjections.add(new StaticInjection(this.injector, request));
        this.injector.getBindingData().putStaticInjectionRequest(request);
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        Set injectionPoints;
        try {
            injectionPoints = request.getInjectionPoints();
        }
        catch (ConfigurationException e) {
            this.errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        this.initializer.requestInjection(this.injector, request.getInstance(), null, request.getSource(), injectionPoints);
        this.injector.getBindingData().putInjectionRequest(new InjectionRequest<Object>(request.getSource(), TypeLiteral.get(request.getInstance().getClass()), null));
        return true;
    }

    void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        ImmutableList<SingleMemberInjector> memberInjectors;

        public StaticInjection(InjectorImpl injector, StaticInjectionRequest request) {
            this.injector = injector;
            this.source = request.getSource();
            this.request = request;
        }

        void validate() {
            Set injectionPoints;
            Errors errorsForMember = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                injectionPoints = this.request.getInjectionPoints();
            }
            catch (ConfigurationException e) {
                errorsForMember.merge(e.getErrorMessages());
                injectionPoints = (Set)e.getPartialValue();
            }
            this.memberInjectors = injectionPoints != null ? this.injector.membersInjectorStore.getInjectors(injectionPoints, errorsForMember) : ImmutableList.of();
            InjectionRequestProcessor.this.errors.merge(errorsForMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectMembers() {
            try (InternalContext context = this.injector.enterContext();){
                boolean isStageTool = this.injector.options.stage == Stage.TOOL;
                for (SingleMemberInjector memberInjector : this.memberInjectors) {
                    if (isStageTool && !memberInjector.getInjectionPoint().isToolable()) continue;
                    try {
                        memberInjector.inject(context, null);
                    }
                    catch (InternalProvisionException e) {
                        InjectionRequestProcessor.this.errors.merge(e);
                    }
                }
            }
        }
    }
}

