/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.bukkit;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.BukkitConsoleSender;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.BukkitPlayerSender;
import org.geysermc.floodgate.shadow.com.google.common.base.Objects;

public abstract class BukkitCommandSender {
    private final CommandSender internalSender;

    protected BukkitCommandSender(@NonNull CommandSender internalSender) {
        this.internalSender = internalSender;
    }

    public static @NonNull BukkitCommandSender player(@NonNull Player player) {
        return new BukkitPlayerSender(player);
    }

    public static @NonNull BukkitCommandSender console() {
        return new BukkitConsoleSender();
    }

    public static @NonNull BukkitCommandSender of(@NonNull CommandSender sender) {
        if (sender instanceof Player) {
            return BukkitCommandSender.player((Player)sender);
        }
        return BukkitCommandSender.console();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitCommandSender that = (BukkitCommandSender)o;
        return Objects.equal(this.internalSender, that.internalSender);
    }

    public final int hashCode() {
        return Objects.hashCode(this.internalSender);
    }

    public @NonNull CommandSender getInternalSender() {
        return this.internalSender;
    }

    public abstract boolean isPlayer();

    public abstract @NonNull Player asPlayer();

    public void sendMessage(@NonNull String message) {
        this.internalSender.sendMessage(message);
    }
}

