/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.standard;

import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.CaptionVariable;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.StandardCaptionKeys;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.ParserException;

public class EnumArgument<C, E extends Enum<E>>
extends CommandArgument<C, E> {
    protected EnumArgument(@NonNull Class<E> enumClass, boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new EnumParser(enumClass), defaultValue, enumClass, suggestionsProvider, defaultDescription);
    }

    public static <C, E extends Enum<E>> @NonNull Builder<C, E> newBuilder(@NonNull Class<E> enumClass, @NonNull String name) {
        return new Builder(name, enumClass);
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> of(@NonNull Class<E> enumClass, @NonNull String name) {
        return EnumArgument.newBuilder(enumClass, name).asRequired().build();
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> optional(@NonNull Class<E> enumClass, @NonNull String name) {
        return EnumArgument.newBuilder(enumClass, name).asOptional().build();
    }

    public static <C, E extends Enum<E>> @NonNull CommandArgument<C, E> optional(@NonNull Class<E> enumClass, @NonNull String name, @NonNull E defaultValue) {
        return EnumArgument.newBuilder(enumClass, name).asOptionalWithDefault(defaultValue.name().toLowerCase()).build();
    }

    public static final class EnumParser<C, E extends Enum<E>>
    implements ArgumentParser<C, E> {
        private final Class<E> enumClass;
        private final EnumSet<E> allowedValues;

        public EnumParser(@NonNull Class<E> enumClass) {
            this.enumClass = enumClass;
            this.allowedValues = EnumSet.allOf(enumClass);
        }

        @Override
        public @NonNull ArgumentParseResult<E> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(EnumParser.class, commandContext));
            }
            for (Enum value : this.allowedValues) {
                if (!value.name().equalsIgnoreCase(input)) continue;
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            return ArgumentParseResult.failure(new EnumParseException(input, this.enumClass, commandContext));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return EnumSet.allOf(this.enumClass).stream().map((? super T e) -> e.name().toLowerCase()).collect(Collectors.toList());
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static final class Builder<C, E extends Enum<E>>
    extends CommandArgument.Builder<C, E> {
        private final Class<E> enumClass;

        private Builder(@NonNull String name, @NonNull Class<E> enumClass) {
            super(enumClass, name);
            this.enumClass = enumClass;
        }

        @Override
        public @NonNull CommandArgument<C, E> build() {
            return new EnumArgument(this.enumClass, this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class EnumParseException
    extends ParserException {
        private static final long serialVersionUID = 3465389578951428862L;
        private final String input;
        private final Class<? extends Enum<?>> enumClass;

        public EnumParseException(@NonNull String input, @NonNull Class<? extends Enum<?>> enumClass, @NonNull CommandContext<?> context) {
            super(EnumParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_ENUM, CaptionVariable.of("input", input), CaptionVariable.of("acceptableValues", EnumParseException.join(enumClass)));
            this.input = input;
            this.enumClass = enumClass;
        }

        private static @NonNull String join(@NonNull Class<? extends Enum> clazz) {
            EnumSet<? extends Enum> enumSet = EnumSet.allOf(clazz);
            return enumSet.stream().map(e -> e.toString().toLowerCase()).collect(Collectors.joining(", "));
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public @NonNull Class<? extends Enum<?>> getEnumClass() {
            return this.enumClass;
        }
    }
}

