/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ProxyUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class SpigotDataHandler
extends CommonDataHandler {
    private Object networkManager;
    private FloodgatePlayer player;
    private boolean proxyData;

    public SpigotDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ReflectionUtils.setValue(this.networkManager, ClassNames.SOCKET_ADDRESS, (Object)newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) throws IllegalStateException {
        if (ClassNames.IS_PRE_1_20_2) {
            ReflectionUtils.setValue(handshakePacket, ClassNames.HANDSHAKE_HOST, (Object)hostname);
            return handshakePacket;
        }
        try {
            Object[] components = new Object[]{ClassNames.HANDSHAKE_PORT.get(handshakePacket), hostname, ClassNames.HANDSHAKE_PROTOCOL.get(handshakePacket), ClassNames.HANDSHAKE_INTENTION.get(handshakePacket)};
            return ClassNames.HANDSHAKE_PACKET_CONSTRUCTOR.newInstance(components);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create new Handshake packet", e);
        }
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        this.proxyData = ProxyUtils.isProxyData();
        if (!this.proxyData) {
            ReflectionUtils.setValue(this.networkManager, "spoofedUUID", (Object)this.player.getCorrectUniqueId());
        }
        return this.proxyData && ClassNames.PAPER_DISABLE_USERNAME_VALIDATION == null;
    }

    @Override
    protected boolean shouldCallFireRead(Object queuedPacket) {
        try {
            if (this.checkAndHandleLogin(queuedPacket)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean channelRead(Object packet) throws Exception {
        if (ClassNames.HANDSHAKE_PACKET.isInstance(packet)) {
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, (String)ReflectionUtils.getCastedValue(packet, ClassNames.HANDSHAKE_HOST));
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) throws Exception {
        if (ClassNames.LOGIN_START_PACKET.isInstance(packet)) {
            Object packetListener = ClassNames.PACKET_LISTENER.get(this.networkManager);
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                this.disconnect(packetListener, kickMessage);
                return true;
            }
            if (!ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            if (ClassNames.PAPER_DISABLE_USERNAME_VALIDATION != null) {
                ReflectionUtils.setValue(packetListener, ClassNames.PAPER_DISABLE_USERNAME_VALIDATION, (Object)true);
                if (this.proxyData) {
                    this.ctx.pipeline().remove((ChannelHandler)this);
                    return false;
                }
            }
            GameProfile gameProfile = new GameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername());
            ReflectionUtils.setValue(packetListener, ClassNames.LOGIN_PROFILE, (Object)gameProfile);
            Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
            if (ClassNames.IS_PRE_1_20_2) {
                ClassNames.INIT_UUID.invoke(packetListener, new Object[0]);
                ClassNames.FIRE_LOGIN_EVENTS.invoke(loginHandler, new Object[0]);
            } else {
                ClassNames.FIRE_LOGIN_EVENTS_GAME_PROFILE.invoke(loginHandler, gameProfile);
            }
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    private void disconnect(Object packetListener, String kickMessage) throws Exception {
        if (ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
            ClassNames.LOGIN_DISCONNECT.invoke(packetListener, kickMessage);
        } else {
            ClassNames.NETWORK_EXCEPTION_CAUGHT.invoke(this.networkManager, this.ctx, new IllegalStateException(kickMessage));
        }
    }
}

