/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.Caption;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.CaptionVariable;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;

public class ParserException
extends IllegalArgumentException {
    private static final long serialVersionUID = -4409795575435072170L;
    private final Class<?> argumentParser;
    private final CommandContext<?> context;
    private final Caption errorCaption;
    private final CaptionVariable[] captionVariables;

    protected ParserException(@NonNull Class<?> argumentParser, @NonNull CommandContext<?> context, @NonNull Caption errorCaption, CaptionVariable ... captionVariables) {
        this.argumentParser = argumentParser;
        this.context = context;
        this.errorCaption = errorCaption;
        this.captionVariables = captionVariables;
    }

    @Override
    public final String getMessage() {
        return this.context.formatMessage(this.errorCaption, this.captionVariables);
    }

    public @NonNull Caption errorCaption() {
        return this.errorCaption;
    }

    public @NonNull CaptionVariable @NonNull [] captionVariables() {
        return Arrays.copyOf(this.captionVariables, this.captionVariables.length);
    }

    public final @NonNull Class<?> getArgumentParserClass() {
        return this.argumentParser;
    }

    public final @NonNull CommandContext<?> getContext() {
        return this.context;
    }
}

