/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.parsers;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.brigadier.argument.WrappedBrigadierParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.BukkitCommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.data.ItemStackPredicate;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.internal.MinecraftArgumentTypes;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

public final class ItemStackPredicateArgument<C>
extends CommandArgument<C, ItemStackPredicate> {
    private ItemStackPredicateArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, ItemStackPredicate.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull ItemStackPredicateArgument<C> of(@NonNull String name) {
        return ItemStackPredicateArgument.builder(name).build();
    }

    public static <C> @NonNull ItemStackPredicateArgument<C> optional(@NonNull String name) {
        return ((Builder)ItemStackPredicateArgument.builder(name).asOptional()).build();
    }

    private static <C> void registerParserSupplier(@NonNull BukkitCommandManager<C> commandManager) {
        commandManager.getParserRegistry().registerParserSupplier(TypeToken.get(ItemStackPredicate.class), params -> new Parser());
    }

    public static final class Parser<C>
    implements ArgumentParser<C, ItemStackPredicate> {
        private static final Class<?> CRAFT_ITEM_STACK_CLASS = CraftBukkitReflection.needOBCClass("inventory.CraftItemStack");
        private static final Class<?> ARGUMENT_ITEM_PREDICATE_CLASS = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"item_predicate"));
        private static final Class<?> ARGUMENT_ITEM_PREDICATE_RESULT_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find ItemPredicateArgument$Result class", CraftBukkitReflection.findNMSClass("ArgumentItemPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.item.ArgumentItemPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.item.ItemPredicateArgument$Result"));
        private static final Method CREATE_PREDICATE_METHOD = CraftBukkitReflection.needMethod(ARGUMENT_ITEM_PREDICATE_RESULT_CLASS, "create", CommandContext.class);
        private static final Method AS_NMS_COPY_METHOD = CraftBukkitReflection.needMethod(CRAFT_ITEM_STACK_CLASS, "asNMSCopy", ItemStack.class);
        private final ArgumentParser<C, ItemStackPredicate> parser;

        public Parser() {
            try {
                this.parser = this.createParser();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to initialize ItemPredicate parser.", ex);
            }
        }

        private ArgumentParser<C, ItemStackPredicate> createParser() throws ReflectiveOperationException {
            return new WrappedBrigadierParser((ArgumentType)ARGUMENT_ITEM_PREDICATE_CLASS.getConstructor(new Class[0]).newInstance(new Object[0])).map((ctx, result) -> {
                Object commandSourceStack = ctx.get("_cloud_brigadier_native_sender");
                CommandContext<Object> dummy = Parser.createDummyContext(ctx, commandSourceStack);
                try {
                    Predicate predicate = (Predicate)CREATE_PREDICATE_METHOD.invoke(result, dummy);
                    return ArgumentParseResult.success(new ItemStackPredicateImpl(predicate));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }

        private static <C> @NonNull CommandContext<Object> createDummyContext(@NonNull org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext<C> ctx, @NonNull Object commandSourceStack) {
            return new CommandContext(commandSourceStack, ctx.getRawInputJoined(), Collections.emptyMap(), null, null, Collections.emptyList(), StringRange.at((int)0), null, null, false);
        }

        @Override
        public @NonNull ArgumentParseResult<@NonNull ItemStackPredicate> parse(@NonNull org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            return this.parser.parse(commandContext, inputQueue);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext<C> commandContext, @NonNull String input) {
            return this.parser.suggestions(commandContext, input);
        }

        private static final class ItemStackPredicateImpl
        implements ItemStackPredicate {
            private final Predicate<Object> predicate;

            ItemStackPredicateImpl(@NonNull Predicate<Object> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(@NonNull ItemStack itemStack) {
                try {
                    return this.predicate.test(AS_NMS_COPY_METHOD.invoke(null, itemStack));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, ItemStackPredicate, Builder<C>> {
        private Builder(@NonNull String name) {
            super(ItemStackPredicate.class, name);
        }

        public @NonNull ItemStackPredicateArgument<C> build() {
            return new ItemStackPredicateArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

