/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.compound;

import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.compound.CompoundArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ParserParameters;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ParserRegistry;
import org.geysermc.floodgate.shadow.cloud.commandframework.types.tuples.Pair;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

public class ArgumentPair<C, U, V, O>
extends CompoundArgument<Pair<U, V>, C, O> {
    protected ArgumentPair(boolean required, @NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> types, @NonNull Pair<@NonNull ArgumentParser<C, U>, @NonNull ArgumentParser<C, V>> parserPair, @NonNull BiFunction<@NonNull C, @NonNull Pair<@NonNull U, @NonNull V>, @NonNull O> mapper, @NonNull TypeToken<O> valueType) {
        super(required, name, names, parserPair, types, mapper, (Object[] o) -> Pair.of(o[0], o[1]), valueType);
    }

    public static <C, U, V> @NonNull ArgumentPairIntermediaryBuilder<C, U, V> of(@NonNull CommandManager<C> manager, @NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> types) {
        ParserRegistry<C> parserRegistry = manager.getParserRegistry();
        ArgumentParser<C, U> firstParser = parserRegistry.createParser(TypeToken.get(types.getFirst()), ParserParameters.empty()).orElseThrow(() -> new IllegalArgumentException("Could not create parser for primary type"));
        ArgumentParser<C, V> secondaryParser = parserRegistry.createParser(TypeToken.get(types.getSecond()), ParserParameters.empty()).orElseThrow(() -> new IllegalArgumentException("Could not create parser for secondary type"));
        return new ArgumentPairIntermediaryBuilder(true, name, names, Pair.of(firstParser, secondaryParser), types);
    }

    public static final class ArgumentPairIntermediaryBuilder<C, U, V> {
        private final boolean required;
        private final String name;
        private final Pair<ArgumentParser<C, U>, ArgumentParser<C, V>> parserPair;
        private final Pair<String, String> names;
        private final Pair<Class<U>, Class<V>> types;

        private ArgumentPairIntermediaryBuilder(boolean required, @NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull ArgumentParser<@NonNull C, @NonNull U>, @NonNull ArgumentParser<@NonNull C, @NonNull V>> parserPair, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> types) {
            this.required = required;
            this.name = name;
            this.names = names;
            this.parserPair = parserPair;
            this.types = types;
        }

        public @NonNull ArgumentPair<@NonNull C, @NonNull U, @NonNull V, @NonNull Pair<@NonNull U, @NonNull V>> simple() {
            return new ArgumentPair<Object, U, V, Pair>(this.required, this.name, this.names, this.types, this.parserPair, (sender, pair) -> pair, new TypeToken<Pair<U, V>>(){});
        }

        public <O> @NonNull ArgumentPair<C, U, V, O> withMapper(@NonNull TypeToken<O> clazz, @NonNull BiFunction<@NonNull C, @NonNull Pair<@NonNull U, @NonNull V>, @NonNull O> mapper) {
            return new ArgumentPair<C, U, V, O>(this.required, this.name, this.names, this.types, this.parserPair, mapper, clazz);
        }

        public <O> @NonNull ArgumentPair<@NonNull C, @NonNull U, @NonNull V, @NonNull O> withMapper(@NonNull Class<O> clazz, @NonNull BiFunction<@NonNull C, @NonNull Pair<@NonNull U, @NonNull V>, @NonNull O> mapper) {
            return this.withMapper(TypeToken.get(clazz), mapper);
        }
    }
}

