/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.updater.file;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigFileUpdaterResult {
    private final List<String> lines;
    private final Map<String, Object> mappedYaml;
    private final Set<String> notMapped;
    private final List<String> changed;
    private final Throwable error;

    private ConfigFileUpdaterResult(List<String> lines, Map<String, Object> mappedYaml, Set<String> notMapped, List<String> changed, Throwable error) {
        this.lines = lines;
        this.mappedYaml = mappedYaml;
        this.notMapped = notMapped;
        this.changed = changed;
        this.error = error;
    }

    public static Ok ok(List<String> lines, Map<String, Object> newVersion, Set<String> notFound, List<String> changed) {
        return new Ok((List)lines, (Map)newVersion, (Set)notFound, (List)changed);
    }

    public static Failed failed(Throwable error) {
        return new Failed(error);
    }

    public @Nullable List<String> lines() {
        return this.lines;
    }

    public @Nullable Map<String, Object> mappedYaml() {
        return this.mappedYaml;
    }

    public @Nullable Set<String> notMappedLines() {
        return this.notMapped;
    }

    public @Nullable List<String> changedLines() {
        return this.changed;
    }

    public @Nullable Throwable error() {
        return this.error;
    }

    public boolean succeeded() {
        return this.error == null;
    }

    public static final class Failed
    extends ConfigFileUpdaterResult {
        private Failed(Throwable error) {
            super(null, null, null, null, error);
        }

        @Override
        public @NonNull Throwable error() {
            return super.error();
        }
    }

    public static final class Ok
    extends ConfigFileUpdaterResult {
        private Ok(List<String> lines, Map<String, Object> newVersion, Set<String> notMapped, List<String> changed) {
            super(lines, newVersion, notMapped, changed, null);
        }

        @Override
        public @NonNull List<String> lines() {
            return super.lines();
        }

        @Override
        public @NonNull Set<String> notMappedLines() {
            return super.notMappedLines();
        }

        @Override
        public @NonNull List<String> changedLines() {
            return super.changedLines();
        }
    }
}

