/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.Collection;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.Utils;

public final class BungeeCommandUtil
extends CommandUtil {
    private final ProxyServer server;
    private UserAudience console;

    public BungeeCommandUtil(LanguageManager manager, ProxyServer server, FloodgateApi api) {
        super(manager, api);
        this.server = server;
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSender)) {
            throw new IllegalArgumentException("Can only work with CommandSource!");
        }
        CommandSender source = (CommandSender)sourceObj;
        if (!(source instanceof ProxiedPlayer)) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(source, this);
            return this.console;
        }
        ProxiedPlayer player = (ProxiedPlayer)source;
        UUID uuid = player.getUniqueId();
        String username = player.getName();
        String locale = Utils.getLocale(player.getLocale());
        return new UserAudience.PlayerAudience(uuid, username, locale, source, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((ProxiedPlayer)source).getName();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((ProxiedPlayer)source).getUniqueId();
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return this.server.getPlayers();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        ProxiedPlayer player = this.server.getPlayer(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        ProxiedPlayer player = this.server.getPlayer(username);
        return player != null ? player : username;
    }

    @Override
    public boolean hasPermission(Object player, String permission) {
        return ((CommandSender)player).hasPermission(permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        ((CommandSender)target).sendMessage(message);
    }

    @Override
    public void kickPlayer(Object player, String message) {
        if (player instanceof ProxiedPlayer) {
            ((ProxiedPlayer)player).disconnect(message);
        }
    }
}

