/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.com.google.inject.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ConstructionContext;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalContext;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalFactory;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalProvisionException;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ProvisionListenerStackCallback;
import org.geysermc.floodgate.shadow.com.google.inject.spi.Dependency;

abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    protected final Object source;

    ProviderInternalFactory(Object source) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T circularGet(final Provider<? extends T> provider, InternalContext context, final Dependency<?> dependency, @Nullable ProvisionListenerStackCallback<T> provisionCallback) throws InternalProvisionException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            Class<?> expectedType = dependency.getKey().getTypeLiteral().getRawType();
            Object proxyType = constructionContext.createProxy(context.getInjectorOptions(), expectedType);
            return (T)proxyType;
        }
        constructionContext.startConstruction();
        try {
            if (provisionCallback == null) {
                T t = this.provision(provider, dependency, constructionContext);
                return t;
            }
            T t = provisionCallback.provision(context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws InternalProvisionException {
                    return ProviderInternalFactory.this.provision(provider, dependency, constructionContext);
                }
            });
            return t;
        }
        finally {
            constructionContext.removeCurrentReference();
            constructionContext.finishConstruction();
        }
    }

    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        T t = provider.get();
        if (t == null && !dependency.isNullable()) {
            InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
        }
        constructionContext.setProxyDelegates(t);
        return t;
    }
}

