/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.bungee;

import java.util.function.Function;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandTree;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.BungeeCaptionKeys;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.BungeeCommandPreprocessor;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.BungeePluginRegistrationHandler;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.arguments.PlayerArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.arguments.ServerArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.captions.FactoryDelegatingCaptionRegistry;
import org.geysermc.floodgate.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import org.geysermc.floodgate.shadow.cloud.commandframework.meta.SimpleCommandMeta;
import org.geysermc.floodgate.shadow.io.leangen.geantyref.TypeToken;

public class BungeeCommandManager<C>
extends CommandManager<C> {
    public static final String ARGUMENT_PARSE_FAILURE_PLAYER = "'{input}' is not a valid player";
    public static final String ARGUMENT_PARSE_FAILURE_SERVER = "'{input}' is not a valid server";
    private final Plugin owningPlugin;
    private final Function<CommandSender, C> commandSenderMapper;
    private final Function<C, CommandSender> backwardsCommandSenderMapper;

    public BungeeCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSender, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSender> backwardsCommandSenderMapper) {
        super(commandExecutionCoordinator, new BungeePluginRegistrationHandler());
        ((BungeePluginRegistrationHandler)this.getCommandRegistrationHandler()).initialize(this);
        this.owningPlugin = owningPlugin;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        this.registerCommandPreProcessor(new BungeeCommandPreprocessor(this));
        this.getParserRegistry().registerParserSupplier(TypeToken.get(ProxiedPlayer.class), parserParameters -> new PlayerArgument.PlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(ServerInfo.class), parserParameters -> new ServerArgument.ServerParser());
        if (this.getCaptionRegistry() instanceof FactoryDelegatingCaptionRegistry) {
            FactoryDelegatingCaptionRegistry factoryDelegatingCaptionRegistry = (FactoryDelegatingCaptionRegistry)this.getCaptionRegistry();
            factoryDelegatingCaptionRegistry.registerMessageFactory(BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, (context, key) -> ARGUMENT_PARSE_FAILURE_PLAYER);
            factoryDelegatingCaptionRegistry.registerMessageFactory(BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, (context, key) -> ARGUMENT_PARSE_FAILURE_SERVER);
        }
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    @Override
    public final @NonNull SimpleCommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    final @NonNull Function<@NonNull CommandSender, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }

    public @NonNull Plugin getOwningPlugin() {
        return this.owningPlugin;
    }
}

