/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news;

import com.google.gson.JsonArray;

public enum NewsItemMessage {
    UPDATE_AVAILABLE("There is an update available for {}. The newest version is: {}"),
    UPDATE_RECOMMENDED((Object)((Object)UPDATE_AVAILABLE) + ". Your version is quite old, updating is recommend."),
    UPDATE_HIGHLY_RECOMMENDED((Object)((Object)UPDATE_AVAILABLE) + ". We highly recommend updating because some important changes have been made."),
    UPDATE_ANCIENT_VERSION((Object)((Object)UPDATE_AVAILABLE) + ". You are running an ancient version, updating is recommended."),
    DOWNTIME_GENERIC("The {} is temporarily going down for maintenance soon."),
    DOWNTIME_WITH_START("The {} is temporarily going down for maintenance on {}."),
    DOWNTIME_TIMEFRAME((Object)((Object)DOWNTIME_WITH_START) + " The maintenance is expected to last till {}.");

    private static final NewsItemMessage[] VALUES;
    private final String messageFormat;
    private final String[] messageSplitted;

    private NewsItemMessage(String messageFormat) {
        this.messageFormat = messageFormat;
        this.messageSplitted = messageFormat.split(" ");
    }

    public static NewsItemMessage getById(int id) {
        return VALUES.length > id ? VALUES[id] : null;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public String getFormattedMessage(JsonArray serverArguments) {
        int serverArgumentsIndex = 0;
        StringBuilder message = new StringBuilder();
        for (String split : this.messageSplitted) {
            String argument;
            if (message.length() > 0) {
                message.append(' ');
            }
            String result = split;
            if (serverArgumentsIndex < serverArguments.size() && !(result = result.replace("{}", argument = serverArguments.get(serverArgumentsIndex).getAsString())).equals(split)) {
                ++serverArgumentsIndex;
            }
            message.append(result);
        }
        return message.toString();
    }

    public String toString() {
        return this.getMessageFormat();
    }

    static {
        VALUES = NewsItemMessage.values();
    }
}

