/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.UUID;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class BungeeListener
implements Listener {
    private static final Field CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(InitialHandler.class, ChannelWrapper.class);
    private static final Field PLAYER_NAME;
    @Inject
    private ProxyFloodgateConfig config;
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;
    @Inject
    private SkinApplier skinApplier;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;

    @EventHandler(priority=-64)
    public void onPreLogin(PreLoginEvent event) {
        if (event.isCancelled()) {
            return;
        }
        PendingConnection connection = event.getConnection();
        ChannelWrapper wrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, CHANNEL_WRAPPER);
        Channel channel = wrapper.getHandle();
        String kickReason = (String)channel.attr(this.kickMessageAttribute).get();
        if (kickReason != null) {
            event.setCancelled(true);
            event.setCancelReason(kickReason);
            return;
        }
        FloodgatePlayer player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
        if (player != null) {
            connection.setOnlineMode(false);
            connection.setUniqueId(player.getCorrectUniqueId());
            ReflectionUtils.setValue((Object)connection, PLAYER_NAME, (Object)player.getCorrectUsername());
        }
    }

    @EventHandler
    public void onLogin(LoginEvent event) {
        UUID uniqueId = event.getConnection().getUniqueId();
        FloodgatePlayer player = this.api.getPlayer(uniqueId);
        if (player != null) {
            this.logger.translatedInfo("floodgate.ingame.login_name", player.getCorrectUsername(), uniqueId);
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @EventHandler(priority=-64)
    public void onPostLogin(PostLoginEvent event) {
        FloodgatePlayer player;
        if (!this.config.isSendFloodgateData() && (player = this.api.getPlayer(event.getPlayer().getUniqueId())) != null && !player.isLinked()) {
            this.skinApplier.applySkin(player, new SkinDataImpl("", ""));
        }
    }

    @EventHandler(priority=64)
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }

    static {
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
        PLAYER_NAME = ReflectionUtils.getField(InitialHandler.class, "name");
        Preconditions.checkNotNull((Object)PLAYER_NAME, (Object)"Initial name field cannot be null");
    }
}

