/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.bungee;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.Varint21LengthFieldExtraBufPrepender;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.util.BungeeReflectionUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class BungeeInjector
extends CommonPlatformInjector {
    private static final String BUNGEE_INIT = "floodgate-bungee-init";
    private final FloodgateLogger logger;
    private boolean injected;

    @Override
    public void inject() {
        Field serverFramePrepender = ReflectionUtils.getField(PipelineUtils.class, "serverFramePrepender");
        if (serverFramePrepender != null) {
            BungeeCustomServerPrepender customServerPrepender = new BungeeCustomServerPrepender(this, (Varint21LengthFieldExtraBufPrepender)ReflectionUtils.castedStaticValue(serverFramePrepender));
            BungeeReflectionUtils.setFieldValue(null, serverFramePrepender, (Object)customServerPrepender);
        }
        Field framePrepender = ReflectionUtils.getField(PipelineUtils.class, "framePrepender");
        BungeeCustomPrepender customPrepender = new BungeeCustomPrepender(this, (Varint21LengthFieldPrepender)ReflectionUtils.castedStaticValue(framePrepender));
        BungeeReflectionUtils.setFieldValue(null, framePrepender, (Object)customPrepender);
        this.injected = true;
    }

    @Override
    public boolean canRemoveInjection() {
        return false;
    }

    @Override
    public void removeInjection() {
        throw new IllegalStateException("Floodgate cannot remove itself from Bungee without a reboot");
    }

    void injectClient(Channel channel, boolean clientToProxy) {
        if (!channel.isOpen()) {
            return;
        }
        if (channel.pipeline().get(MinecraftEncoder.class) == null) {
            this.logger.debug("Minecraft encoder not found while injecting! {}", String.join((CharSequence)", ", channel.pipeline().names()));
            return;
        }
        this.injectAddonsCall(channel, !clientToProxy);
        this.addInjectedClient(channel);
    }

    public BungeeInjector(FloodgateLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    private static final class BungeeProxyToServerInjectInitializer
    extends ChannelOutboundHandlerAdapter {
        private final BungeeInjector injector;

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.injector.injectClient(ctx.channel(), false);
            ctx.pipeline().remove((ChannelHandler)this);
            super.write(ctx, msg, promise);
        }

        public BungeeProxyToServerInjectInitializer(BungeeInjector injector) {
            this.injector = injector;
        }
    }

    private static final class BungeeClientToProxyInjectInitializer
    extends ChannelInboundHandlerAdapter {
        private final BungeeInjector injector;

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.injector.injectClient(ctx.channel(), true);
            ctx.pipeline().remove((ChannelHandler)this);
            super.channelRead(ctx, msg);
        }

        public BungeeClientToProxyInjectInitializer(BungeeInjector injector) {
            this.injector = injector;
        }
    }

    private static final class BungeeCustomServerPrepender
    extends Varint21LengthFieldExtraBufPrepender {
        private final BungeeInjector injector;
        private final Varint21LengthFieldExtraBufPrepender original;

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.original.handlerAdded(ctx);
            ctx.pipeline().addLast(BungeeInjector.BUNGEE_INIT, (ChannelHandler)new BungeeProxyToServerInjectInitializer(this.injector));
        }

        public BungeeCustomServerPrepender(BungeeInjector injector, Varint21LengthFieldExtraBufPrepender original) {
            this.injector = injector;
            this.original = original;
        }
    }

    private static final class BungeeCustomPrepender
    extends Varint21LengthFieldPrepender {
        private final BungeeInjector injector;
        private final Varint21LengthFieldPrepender original;

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.original.handlerAdded(ctx);
            if (ctx.channel().parent() != null) {
                ctx.pipeline().addBefore("frame-decoder", BungeeInjector.BUNGEE_INIT, (ChannelHandler)new BungeeClientToProxyInjectInitializer(this.injector));
            } else {
                ctx.pipeline().addLast(BungeeInjector.BUNGEE_INIT, (ChannelHandler)new BungeeProxyToServerInjectInitializer(this.injector));
            }
        }

        public BungeeCustomPrepender(BungeeInjector injector, Varint21LengthFieldPrepender original) {
            this.injector = injector;
            this.original = original;
        }
    }
}

