/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Handshake;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ReflectionUtils;

public class BungeeProxyDataHandler
extends CommonDataHandler {
    private static final Field HANDLER = ReflectionUtils.getField(HandlerBoss.class, "handler");
    private static final Field CHANNEL_WRAPPER;

    public BungeeProxyDataHandler(FloodgateHandshakeHandler handshakeHandler, ProxyFloodgateConfig config, AttributeKey<String> kickMessageAttribute, PacketBlocker blocker) {
        super(handshakeHandler, config, kickMessageAttribute, blocker);
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        HandlerBoss handlerBoss = (HandlerBoss)this.ctx.pipeline().get(HandlerBoss.class);
        InitialHandler connection = (InitialHandler)ReflectionUtils.getCastedValue((Object)handlerBoss, HANDLER);
        ChannelWrapper channelWrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, CHANNEL_WRAPPER);
        channelWrapper.setRemoteAddress((SocketAddress)newIp);
    }

    @Override
    protected Object setHostname(Object wrapperWithHandshake, String hostname) {
        PacketWrapper wrapper = (PacketWrapper)wrapperWithHandshake;
        Handshake handshake = (Handshake)wrapper.packet;
        handshake.setHost(hostname);
        return wrapper;
    }

    @Override
    public boolean channelRead(Object msg) {
        DefinedPacket packet;
        if (msg instanceof PacketWrapper && (packet = ((PacketWrapper)msg).packet) instanceof Handshake) {
            this.handle(msg, ((Handshake)packet).getHost());
            return false;
        }
        return true;
    }

    static {
        Preconditions.checkNotNull((Object)HANDLER, (Object)"handler field cannot be null");
        CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(InitialHandler.class, ChannelWrapper.class);
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
    }
}

