/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.updater.change;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.configutils.updater.change.Version;

public final class VersionBuilder {
    private final Map<String, String> keyRenames = new HashMap<String, String>();
    private final Map<String, Map<Object, Object>> valueRemoves = new HashMap<String, Map<Object, Object>>();

    VersionBuilder() {
    }

    public @NonNull VersionBuilder keyRenamed(@NonNull String oldName, @NonNull String newName) {
        Objects.requireNonNull(oldName);
        Objects.requireNonNull(newName);
        this.keyRenames.put(newName, oldName);
        return this;
    }

    public @NonNull VersionBuilder valueChanged(@NonNull String key, @NonNull Object oldValue, @NonNull Object newValue) {
        return this.valueRemoved(key, oldValue, newValue);
    }

    public @NonNull VersionBuilder valueRemoved(@NonNull String key, @NonNull Object removedValue, @NonNull Object fallback) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(removedValue);
        Objects.requireNonNull(fallback);
        Map removes = this.valueRemoves.getOrDefault(key, new HashMap());
        removes.put(removedValue, fallback);
        if (removes.size() == 1) {
            this.valueRemoves.put(key, removes);
        }
        return this;
    }

    public @NonNull Version build(int versionNumber) {
        return new Version(versionNumber, this.keyRenames, this.valueRemoves);
    }
}

