/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.geysermc.event.Listener;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.event.lifecycle.PostEnableEvent;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.util.AutoBind;
import org.geysermc.floodgate.util.MessageFormatter;
import org.geysermc.floodgate.util.Utils;

@AutoBind
@Listener
public final class PostEnableMessages {
    private final List<String> messages = new ArrayList<String>();
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="commonScheduledPool")
    private ScheduledExecutorService executorService;

    public void add(String[] message, Object ... args) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n**********************************\n");
        for (String part : message) {
            builder.append("* ").append(part).append('\n');
        }
        builder.append("**********************************");
        this.messages.add(MessageFormatter.format(builder.toString(), args));
    }

    @Inject
    private void init() {
        this.registerPrefixMessages();
    }

    private void registerPrefixMessages() {
        String prefix = this.config.getRawUsernamePrefix();
        if (prefix.isEmpty()) {
            this.add(new String[]{"You specified an empty prefix in your Floodgate config for Bedrock players!", "Should a Java player join and a Bedrock player join with the same username, unwanted results and conflicts will happen!", "We strongly recommend using . as the prefix, but other alternatives that will not conflict include: +, - and *"}, new Object[0]);
        } else if (!Utils.isUniquePrefix(prefix)) {
            this.add(new String[]{"The prefix you entered in your Floodgate config ({}) could lead to username conflicts!", "Should a Java player join with the username {}Notch, and a Bedrock player join as Notch (who will be given the name {}Notch), unwanted results will happen!", "We strongly recommend using . as the prefix, but other alternatives that will not conflict include: +, - and *"}, prefix, prefix, prefix, prefix);
        }
        if (prefix.length() >= 16) {
            this.add(new String[]{"The prefix you entered in your Floodgate config ({}) is longer than a Java username can be!", "Because of this, we reset the prefix to the default Floodgate prefix (.)"}, prefix);
        } else if (prefix.length() > 2) {
            this.add(new String[]{"The prefix you entered in your Floodgate config ({}) is long! ({} characters)", "A prefix is there to prevent username conflicts. However, a long prefix makes the chance of username conflicts higher.", "We strongly recommend using . as the prefix, but other alternatives that will not conflict include: +, - and *"}, prefix, prefix.length());
        }
    }

    @Subscribe
    public void onPostEnable(PostEnableEvent ignored) {
        this.executorService.schedule(() -> this.messages.forEach(x$0 -> this.logger.warn((String)x$0, new Object[0])), this.config.isProxy() ? 2L : 5L, TimeUnit.SECONDS);
    }
}

