/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.lang.reflect.Field;
import java.util.List;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.geysermc.floodgate.platform.util.PlatformUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class BungeePlatformUtils
extends PlatformUtils {
    private static final String LATEST_SUPPORTED_VERSION;
    private final ProxyServer proxyServer = ProxyServer.getInstance();

    @Override
    public PlatformUtils.AuthType authType() {
        return this.proxyServer.getConfig().isOnlineMode() ? PlatformUtils.AuthType.ONLINE : PlatformUtils.AuthType.OFFLINE;
    }

    @Override
    public String minecraftVersion() {
        return LATEST_SUPPORTED_VERSION;
    }

    @Override
    public String serverImplementationName() {
        return this.proxyServer.getName();
    }

    static {
        int protocolNumber = -1;
        String versionName = "";
        for (Field field : ProtocolConstants.class.getFields()) {
            int fieldValue;
            if (!field.getName().startsWith("MINECRAFT_") || (fieldValue = ((Integer)ReflectionUtils.castedStaticValue(field)).intValue()) <= protocolNumber) continue;
            protocolNumber = fieldValue;
            versionName = field.getName().substring(10).replace('_', '.');
        }
        if (protocolNumber == -1) {
            List versions = ProtocolConstants.SUPPORTED_VERSIONS;
            versionName = (String)versions.get(versions.size() - 1);
        }
        LATEST_SUPPORTED_VERSION = versionName;
    }
}

