/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.com.google.inject.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.geysermc.floodgate.shadow.com.google.inject.Binder;
import org.geysermc.floodgate.shadow.com.google.inject.ConfigurationException;
import org.geysermc.floodgate.shadow.com.google.inject.TypeLiteral;
import org.geysermc.floodgate.shadow.com.google.inject.spi.Element;
import org.geysermc.floodgate.shadow.com.google.inject.spi.ElementVisitor;
import org.geysermc.floodgate.shadow.com.google.inject.spi.InjectionPoint;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type, T instance) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.type = (TypeLiteral)Preconditions.checkNotNull(type, (Object)"type");
        this.instance = instance;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.instance != null ? TypeLiteral.get(this.instance.getClass()) : this.type);
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }

    public boolean equals(Object obj) {
        return obj instanceof InjectionRequest && Objects.equal(((InjectionRequest)obj).instance, this.instance) && ((InjectionRequest)obj).type.equals(this.type) && ((InjectionRequest)obj).source.equals(this.source);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.source});
    }
}

