/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Set;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ConstructionProxyFactory;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ConstructorInjector;
import org.geysermc.floodgate.shadow.com.google.inject.internal.DefaultConstructionProxyFactory;
import org.geysermc.floodgate.shadow.com.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ErrorsException;
import org.geysermc.floodgate.shadow.com.google.inject.internal.FailableCache;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.com.google.inject.internal.InternalFlags;
import org.geysermc.floodgate.shadow.com.google.inject.internal.MembersInjectorImpl;
import org.geysermc.floodgate.shadow.com.google.inject.internal.MethodAspect;
import org.geysermc.floodgate.shadow.com.google.inject.internal.ProxyFactory;
import org.geysermc.floodgate.shadow.com.google.inject.internal.SingleParameterInjector;
import org.geysermc.floodgate.shadow.com.google.inject.spi.InjectionPoint;
import org.geysermc.floodgate.shadow.com.google.inject.spi.InterceptorBinding;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<InterceptorBinding> injectorBindings = this.injector.getBindingData().getInterceptorBindings();
            ImmutableList methodAspects = ImmutableList.builder().addAll((Iterable)Lists.transform(injectorBindings, MethodAspect::fromBinding)).addAll(membersInjector.getAddedAspects()).build();
            factory = new ProxyFactory(injectionPoint, (Iterable<MethodAspect>)methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector((Set<InjectionPoint>)membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

