/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser;

import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ArgumentParseResult<T> {
    private ArgumentParseResult() {
    }

    public static <T> @NonNull ArgumentParseResult<T> failure(@NonNull Throwable failure) {
        return new ParseFailure(failure);
    }

    public static <T> @NonNull ArgumentParseResult<T> success(@NonNull T value) {
        return new ParseSuccess(value);
    }

    public abstract @NonNull Optional<T> getParsedValue();

    public abstract <U> @NonNull ArgumentParseResult<U> mapParsedValue(Function<T, U> var1);

    public abstract <U> @NonNull ArgumentParseResult<U> flatMapParsedValue(Function<T, ArgumentParseResult<U>> var1);

    public abstract @NonNull Optional<Throwable> getFailure();

    public abstract @NonNull ArgumentParseResult<T> mapFailure(Function<Throwable, Throwable> var1);

    private static final class ParseFailure<T>
    extends ArgumentParseResult<T> {
        private final Throwable failure;

        private ParseFailure(@NonNull Throwable failure) {
            this.failure = failure;
        }

        @Override
        public @NonNull Optional<T> getParsedValue() {
            return Optional.empty();
        }

        @Override
        public <U> @NonNull ArgumentParseResult<U> mapParsedValue(Function<T, U> mapper) {
            return this;
        }

        @Override
        public <U> @NonNull ArgumentParseResult<U> flatMapParsedValue(Function<T, ArgumentParseResult<U>> mapper) {
            return this;
        }

        @Override
        public @NonNull Optional<Throwable> getFailure() {
            return Optional.of(this.failure);
        }

        @Override
        public @NonNull ArgumentParseResult<T> mapFailure(Function<Throwable, Throwable> mapper) {
            return new ParseFailure<T>(mapper.apply(this.failure));
        }
    }

    private static final class ParseSuccess<T>
    extends ArgumentParseResult<T> {
        private final T value;

        private ParseSuccess(@NonNull T value) {
            this.value = value;
        }

        @Override
        public @NonNull Optional<T> getParsedValue() {
            return Optional.of(this.value);
        }

        @Override
        public <U> @NonNull ArgumentParseResult<U> mapParsedValue(Function<T, U> mapper) {
            return new ParseSuccess<U>(mapper.apply(this.value));
        }

        @Override
        public <U> @NonNull ArgumentParseResult<U> flatMapParsedValue(Function<T, ArgumentParseResult<U>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public @NonNull Optional<Throwable> getFailure() {
            return Optional.empty();
        }

        @Override
        public @NonNull ArgumentParseResult<T> mapFailure(Function<Throwable, Throwable> mapper) {
            return this;
        }
    }
}

