/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.Property;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.event.EventBus;
import org.geysermc.floodgate.event.skin.SkinApplyEventImpl;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.ReflectionUtils;

@Singleton
public final class BungeeSkinApplier
implements SkinApplier {
    private static final Field LOGIN_RESULT_FIELD = ReflectionUtils.getFieldOfType(InitialHandler.class, LoginResult.class);
    private final ProxyServer server = ProxyServer.getInstance();
    @Inject
    private EventBus eventBus;
    @Inject
    private FloodgateLogger logger;

    @Override
    public void applySkin(@NonNull FloodgatePlayer floodgatePlayer,  @NonNull SkinApplyEvent.SkinData skinData) {
        InitialHandler handler;
        ProxiedPlayer player = this.server.getPlayer(floodgatePlayer.getCorrectUniqueId());
        if (player == null) {
            return;
        }
        try {
            handler = (InitialHandler)player.getPendingConnection();
        }
        catch (Exception exception) {
            this.logger.error("Incompatible Bungeecord fork detected", exception, new Object[0]);
            return;
        }
        LoginResult loginResult = handler.getLoginProfile();
        if (loginResult == null) {
            loginResult = new LoginResult(null, null, new Property[0]);
            ReflectionUtils.setValue((Object)handler, LOGIN_RESULT_FIELD, (Object)loginResult);
        }
        Property[] properties = loginResult.getProperties();
        SkinApplyEvent.SkinData currentSkin = this.currentSkin(properties);
        SkinApplyEventImpl event = new SkinApplyEventImpl(floodgatePlayer, currentSkin, skinData);
        event.setCancelled(floodgatePlayer.isLinked());
        this.eventBus.fire(event);
        if (event.isCancelled()) {
            return;
        }
        loginResult.setProperties(this.replaceSkin(properties, event.newSkin()));
    }

    private SkinApplyEvent.SkinData currentSkin(Property[] properties) {
        for (Property property : properties) {
            if (!property.getName().equals("textures") || property.getValue().isEmpty()) continue;
            return new SkinDataImpl(property.getValue(), property.getSignature());
        }
        return null;
    }

    private Property[] replaceSkin(Property[] properties, SkinApplyEvent.SkinData skinData) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property property : properties) {
            if (property.getName().equals("textures")) continue;
            list.add(property);
        }
        list.add(new Property("textures", skinData.value(), skinData.signature()));
        return list.toArray(new Property[0]);
    }

    static {
        Preconditions.checkNotNull((Object)LOGIN_RESULT_FIELD, (Object)"LoginResult field cannot be null");
    }
}

