/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import java.util.UUID;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;

public final class BungeePluginMessageUtils
extends PluginMessageUtils
implements Listener {
    private final PluginMessageManager pluginMessageManager;
    private final FloodgateLogger logger;

    @EventHandler(priority=-32)
    public void onPluginMessage(PluginMessageEvent event) {
        PluginMessageChannel channel = this.pluginMessageManager.getChannel(event.getTag());
        if (channel == null) {
            return;
        }
        UUID sourceUuid = null;
        String sourceUsername = null;
        PluginMessageChannel.Identity sourceIdentity = PluginMessageChannel.Identity.UNKNOWN;
        Connection source = event.getSender();
        if (source instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)source;
            sourceUuid = player.getUniqueId();
            sourceUsername = player.getName();
            sourceIdentity = PluginMessageChannel.Identity.PLAYER;
        } else if (source instanceof ServerConnection) {
            sourceIdentity = PluginMessageChannel.Identity.SERVER;
        }
        PluginMessageChannel.Result result = channel.handleProxyCall(event.getData(), sourceUuid, sourceUsername, sourceIdentity);
        event.setCancelled(!result.isAllowed());
        if (!result.isAllowed() && result.getReason() != null) {
            this.logKick(source, result.getReason());
        }
    }

    private void logKick(Connection source, String reason) {
        this.logger.error(reason + " Closing connection", new Object[0]);
        source.disconnect((BaseComponent)new TextComponent(reason));
    }

    @Override
    public boolean sendMessage(UUID player, boolean toServer, String channel, byte[] data) {
        ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(player);
        if (proxiedPlayer == null) {
            return false;
        }
        if (toServer) {
            proxiedPlayer.getServer().sendData(channel, data);
        } else {
            proxiedPlayer.sendData(channel, data);
        }
        return true;
    }

    public BungeePluginMessageUtils(PluginMessageManager pluginMessageManager, FloodgateLogger logger) {
        this.pluginMessageManager = pluginMessageManager;
        this.logger = logger;
    }
}

