/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import java.util.logging.Logger;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.geysermc.floodgate.BungeePlugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.bungee.BungeeInjector;
import org.geysermc.floodgate.listener.BungeeListenerRegistration;
import org.geysermc.floodgate.logger.JavaUtilFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.platform.util.PlatformUtils;
import org.geysermc.floodgate.player.FloodgateCommandPreprocessor;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.pluginmessage.BungeePluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.BungeePluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.BungeeSkinApplier;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.bungee.BungeeCommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import org.geysermc.floodgate.shadow.com.google.inject.AbstractModule;
import org.geysermc.floodgate.shadow.com.google.inject.Provides;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.shadow.com.google.inject.name.Names;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.BungeeCommandUtil;
import org.geysermc.floodgate.util.BungeePlatformUtils;
import org.geysermc.floodgate.util.LanguageManager;

public final class BungeePlatformModule
extends AbstractModule {
    private final BungeePlugin plugin;

    @Override
    protected void configure() {
        this.bind(PlatformUtils.class).to(BungeePlatformUtils.class);
        this.bind(Logger.class).annotatedWith(Names.named("logger")).toInstance(this.plugin.getLogger());
        this.bind(FloodgateLogger.class).to(JavaUtilFloodgateLogger.class);
        this.bind(SkinApplier.class).to(BungeeSkinApplier.class);
    }

    @Provides
    @Singleton
    public Plugin bungeePlugin() {
        return this.plugin;
    }

    @Provides
    @Singleton
    public CommandManager<UserAudience> commandManager(CommandUtil commandUtil) {
        BungeeCommandManager<UserAudience> commandManager = new BungeeCommandManager<UserAudience>(this.plugin, CommandExecutionCoordinator.simpleCoordinator(), commandUtil::getUserAudience, audience -> (CommandSender)audience.source());
        commandManager.registerCommandPreProcessor(new FloodgateCommandPreprocessor(commandUtil));
        return commandManager;
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(FloodgateApi api, LanguageManager languageManager) {
        return new BungeeCommandUtil(languageManager, this.plugin.getProxy(), api);
    }

    @Provides
    @Singleton
    public ListenerRegistration<Listener> listenerRegistration() {
        return new BungeeListenerRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils(PluginMessageManager manager, FloodgateLogger logger) {
        return new BungeePluginMessageUtils(manager, logger);
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegistration() {
        return new BungeePluginMessageRegistration();
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector(FloodgateLogger logger) {
        return new BungeeInjector(logger);
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "packet-encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "packet-decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "inbound-boss";
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Bungeecord";
    }

    public BungeePlatformModule(BungeePlugin plugin) {
        this.plugin = plugin;
    }
}

