/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.link.LinkRequestResult;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.link.CommonPlayerLink;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.util.HttpClient;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.Utils;

public class GlobalPlayerLinking
extends CommonPlayerLink {
    @Inject
    private HttpClient httpClient;
    private PlayerLink databaseImpl;

    public void setDatabaseImpl(PlayerLink databaseImpl) {
        if (this.databaseImpl == null) {
            this.databaseImpl = databaseImpl;
        }
    }

    @Override
    public void load() {
        if (this.databaseImpl != null) {
            this.databaseImpl.load();
        }
    }

    @Override
    public String getName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getName();
        }
        return null;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.databaseImpl != null) {
            this.databaseImpl.stop();
        }
    }

    @Override
    public @NonNull CompletableFuture<LinkedPlayer> getLinkedPlayer(@NonNull UUID bedrockId) {
        if (this.databaseImpl == null) {
            return this.getLinkedPlayer0(bedrockId);
        }
        return this.databaseImpl.getLinkedPlayer(bedrockId).thenComposeAsync(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.getLinkedPlayer0(bedrockId);
        });
    }

    private @NonNull CompletableFuture<LinkedPlayer> getLinkedPlayer0(@NonNull UUID bedrockId) {
        return CompletableFuture.supplyAsync(() -> {
            HttpClient.DefaultHttpResponse response = this.httpClient.get("https://api.geysermc.org/v2/link/bedrock/" + bedrockId.getLeastSignificantBits());
            if (!response.isCodeOk()) {
                if (response.getResponse() != null) {
                    this.getLogger().error("Failed to request link for {}: {}", bedrockId.getLeastSignificantBits(), ((JsonObject)response.getResponse()).get("message").getAsString());
                }
                return null;
            }
            JsonObject data = (JsonObject)response.getResponse();
            JsonElement javaName = data.get("java_name");
            if (javaName == null) {
                return null;
            }
            return LinkedPlayer.of(javaName.getAsString(), UUID.fromString(data.get("java_id").getAsString()), Utils.getJavaUuid(data.get("bedrock_id").getAsLong()));
        }, this.getExecutorService());
    }

    @Override
    public @NonNull CompletableFuture<Boolean> isLinkedPlayer(@NonNull UUID bedrockId) {
        if (this.databaseImpl == null) {
            return this.isLinkedPlayer0(bedrockId);
        }
        return this.databaseImpl.isLinkedPlayer(bedrockId).thenComposeAsync(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.isLinkedPlayer0(bedrockId);
        });
    }

    private @NonNull CompletableFuture<Boolean> isLinkedPlayer0(@NonNull UUID bedrockId) {
        return CompletableFuture.supplyAsync(() -> {
            HttpClient.DefaultHttpResponse response = this.httpClient.get("https://api.geysermc.org/v2/link/bedrock/" + bedrockId.getLeastSignificantBits());
            if (!response.isCodeOk()) {
                this.getLogger().error("Failed to request link for {}: {}", bedrockId.getLeastSignificantBits(), ((JsonObject)response.getResponse()).get("message").getAsString());
                return false;
            }
            return ((JsonObject)response.getResponse()).entrySet().size() != 0;
        }, this.getExecutorService());
    }

    @Override
    public @NonNull CompletableFuture<Void> linkPlayer(@NonNull UUID bedrockId, @NonNull UUID javaId, @NonNull String username) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.linkPlayer(bedrockId, javaId, username);
        }
        return this.failedFuture();
    }

    @Override
    public @NonNull CompletableFuture<Void> unlinkPlayer(@NonNull UUID javaId) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.unlinkPlayer(javaId);
        }
        return this.failedFuture();
    }

    @Override
    public @NonNull CompletableFuture<?> createLinkRequest(@NonNull UUID javaId, @NonNull String javaUsername, @NonNull String bedrockUsername) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.createLinkRequest(javaId, javaUsername, bedrockUsername);
        }
        return this.failedFuture();
    }

    @Override
    public @NonNull CompletableFuture<LinkRequestResult> verifyLinkRequest(@NonNull UUID bedrockId, @NonNull String javaUsername, @NonNull String bedrockUsername, @NonNull String code) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.verifyLinkRequest(bedrockId, javaUsername, bedrockUsername, code);
        }
        return this.failedFuture();
    }

    @Override
    public boolean isEnabledAndAllowed() {
        return this.databaseImpl != null && this.databaseImpl.isEnabledAndAllowed();
    }

    private <U> CompletableFuture<U> failedFuture() {
        return Utils.failedFuture(new IllegalStateException("Cannot perform this action when Global Linking is enabled"));
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public PlayerLink getDatabaseImpl() {
        return this.databaseImpl;
    }
}

