/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.geysermc.floodgate.addon.debug.StateChangeDetector;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

@ChannelHandler.Sharable
public final class ChannelOutDebugHandler
extends MessageToByteEncoder<ByteBuf> {
    private final String direction;
    private final FloodgateLogger logger;
    private final boolean toServer;
    private final StateChangeDetector changeDetector;

    public ChannelOutDebugHandler(String implementationType, boolean toServer, StateChangeDetector changeDetector, FloodgateLogger logger) {
        this.direction = implementationType + (toServer ? " -> Server" : " -> Player");
        this.logger = logger;
        this.toServer = toServer;
        this.changeDetector = changeDetector;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        try {
            int index = msg.readerIndex();
            if (this.changeDetector.shouldPrintPacket(msg, this.toServer)) {
                this.logger.info("{} {}:\n{}", new Object[]{this.direction, this.changeDetector.getCurrentState(), ByteBufUtil.prettyHexDump((ByteBuf)msg)});
                this.changeDetector.checkPacket(msg, this.toServer);
            }
            msg.readerIndex(index);
            out.writeBytes(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

