/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.packet.Handshake;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.ReflectionUtils;

public class BungeeServerDataHandler
extends ChannelOutboundHandlerAdapter {
    private static final Field HANDLER = ReflectionUtils.getField(HandlerBoss.class, "handler");
    private static final Field USER_CONNECTION;
    private static final Field CHANNEL_WRAPPER;
    private final ProxyFloodgateApi api;
    private final AttributeKey<FloodgatePlayer> playerAttribute;

    public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) {
        if (packet instanceof Handshake) {
            HandlerBoss handlerBoss = (HandlerBoss)ctx.pipeline().get(HandlerBoss.class);
            PacketHandler handler = (PacketHandler)ReflectionUtils.getCastedValue((Object)handlerBoss, HANDLER);
            if (!(handler instanceof ServerConnector)) {
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.write(packet, promise);
                return;
            }
            UserConnection connection = (UserConnection)ReflectionUtils.getCastedValue((Object)handler, USER_CONNECTION);
            ChannelWrapper wrapper = (ChannelWrapper)ReflectionUtils.getCastedValue((Object)connection, CHANNEL_WRAPPER);
            FloodgatePlayer player = (FloodgatePlayer)wrapper.getHandle().attr(this.playerAttribute).get();
            if (player != null) {
                String remaining;
                String originalAddress;
                BedrockData data = player.as(FloodgatePlayerImpl.class).toBedrockData();
                String encryptedData = this.api.createEncryptedDataString(data);
                Handshake handshake = (Handshake)packet;
                String address = handshake.getHost();
                int addressFinished = address.indexOf(0);
                if (addressFinished != -1) {
                    originalAddress = address.substring(0, addressFinished);
                    remaining = address.substring(addressFinished);
                } else {
                    originalAddress = address;
                    remaining = "";
                }
                handshake.setHost(originalAddress + '\u0000' + encryptedData + remaining);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.write(packet, promise);
    }

    public BungeeServerDataHandler(ProxyFloodgateApi api, AttributeKey<FloodgatePlayer> playerAttribute) {
        this.api = api;
        this.playerAttribute = playerAttribute;
    }

    static {
        Preconditions.checkNotNull((Object)HANDLER, (Object)"handler field cannot be null");
        USER_CONNECTION = ReflectionUtils.getField(ServerConnector.class, "user");
        Preconditions.checkNotNull((Object)USER_CONNECTION, (Object)"user field cannot be null");
        CHANNEL_WRAPPER = ReflectionUtils.getFieldOfType(UserConnection.class, ChannelWrapper.class);
        Preconditions.checkNotNull((Object)CHANNEL_WRAPPER, (Object)"ChannelWrapper field cannot be null");
    }
}

