/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.loader.validate;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.exception.ImproperConfigValueException;

public class ValidationResult {
    private final ImproperConfigValueException error;
    private final Object value;

    private ValidationResult(ImproperConfigValueException error, Object value) {
        this.error = error;
        this.value = value;
    }

    public static @NonNull ValidationResult ok(@NonNull Object value) {
        return new ValidationResult(null, Objects.requireNonNull(value));
    }

    public static @NonNull ValidationResult failed(@NonNull String errorMessage) {
        Objects.requireNonNull(errorMessage);
        return new ValidationResult(new ImproperConfigValueException(errorMessage), null);
    }

    public @Nullable ImproperConfigValueException error() {
        return this.error;
    }

    public @Nullable Object value() {
        return this.value;
    }

    public boolean success() {
        return this.error == null;
    }
}

